extends Control

export var tooltip = ""
export var description = ""
export var action = ""
export(String,FILE) var events_path = ""
export var global_id = ""
export var use_combine = false
export var inventory = false
export var use_action_menu = true
export(int, "frente", "3cuartos_derecha", "perfil_derecha", "3cuartos_espalda_derecha", "espalda", "3cuartos_espalda_izquierda", "perfil_izquierda", "3cuartos_izquierda") var interact_pose
export var talk_animation = "talk"

var states
var state = ""
var anim_notify = null

var event_table = {}
var vm

#func _set(name, val):
#	if name == "events_path":
#		event_table = vm.compile(val)
#		events_path = val
#		return
#	if name in self:
#		self[name] = val

func anim_finished():
	if typeof(anim_notify) != typeof(null):
		vm.finished(anim_notify)
		anim_notify = null

func set_active(p_active):
	if p_active:
		show()
	else:
		hide()

func run_event(p_ev):
	vm.run_event(p_ev)

func activate(p_action, p_param = null):
	if typeof(p_param) != typeof(null):
		p_action = p_action + " " + p_param.global_id
	if p_action in event_table:
		run_event(event_table[p_action])
	elif p_action == "look" && description != "":
		run_event([ { "name": "say", "params": ["player", description, "double"] } ] )
	else:
		return false

	return true

func get_action():
	return action

func mouse_enter():
	get_scene().call_group(0, "game", "mouse_enter", self)

func mouse_exit():
	get_scene().call_group(0, "game", "mouse_exit", self)

func input(event):
	if event.type == InputEvent.MOUSE_BUTTON && event.pressed:
		get_scene().call_group(0, "game", "clicked", self, get_pos())

func global_changed(name):
	var ev = "global_changed "+name
	if ev in event_table:
		run_event(event_table[ev])
	elif "global_changed" in event_table:
		run_event(event_table.global_changed)

func play_anim(p_anim, p_notify = null):

	if typeof(p_notify) != typeof(null) && (!has_node("animation") || !get_node("animation").has_animation(p_anim)):
		print("skipping cut scene '", p_anim, "'")
		vm.finished(p_notify)
		return

	get_node("animation").play(p_anim)
	anim_notify = p_notify

func set_speaking(p_speaking):
	if !has_node("animation"):
		return
	if talk_animation == "":
		return
	if p_speaking:
		if get_node("animation").has_animation(talk_animation):
			states.stop()
			get_node("animation").play(talk_animation)
	else:
		if get_node("animation").is_playing():
			get_node("animation").stop()
			set_state(state)
	pass

func set_state(p_state):
	state = p_state
	if states != null:
		if states.is_playing() && states.get_current_animation() == p_state:
			return
		if states.has_animation(p_state):
			states.play(p_state)

func teleport(obj):
	set_pos(obj.get_global_pos())

func teleport_pos(x, y):
	set_pos(Vector2(x, y))

func _ready():
	states = get_node("states")
	connect("input_event", self, "input")
	connect("mouse_enter", self, "mouse_enter")
	connect("mouse_exit", self, "mouse_exit")
	vm = get_scene().get_singleton("vm")
	vm.connect("global_changed", self, "global_changed")
	if events_path != "":
		event_table = vm.compile(events_path)
	if global_id != "":
		vm.register_object(global_id, self)
	if has_node("animation"):
		get_node("animation").connect("finished", self, "anim_finished")

