extends "res://game/objects/item.gd"

var catching_input = false

export var music_volume = 1.0

func set_input_catch(p_catch):
	if catching_input == p_catch:
		return
	get_node("input_catch").set_ignore_mouse(!p_catch)
	catching_input = p_catch
	return
	printt("********** setting input catch ", p_catch)
	var anim = get_node("animation")
	if p_catch:
		anim.play("catch_input")
	else:
		anim.play("release_input")
	catching_input = p_catch

func input_event(event):
	if event.type == InputEvent.MOUSE_BUTTON && event.pressed && event.button_index == BUTTON_LEFT:
		print("sending event skipped!")
		get_scene().call_group(0, "events", "skipped")

func game_cleared():
	if global_id != "":
		vm.register_object(global_id, self)

func set_volume(p_vol):
	AS.set_stream_global_volume_scale(p_vol)

func _process(time):
	set_volume(music_volume)

func _ready():
	#._ready()
	get_node("input_catch").connect("input_event", self, "input_event")
	get_node("animation").play("input_release")
	add_to_group("game")
