extends SceneSingleton

var stack = []
var globals = {}
var objects = {}
var inventory = {}

var scenes_cache = []

var state_return = 0
var state_yield = 1
var state_break = 2
var state_repeat = 3
var state_call = 4
var state_jump = 5

var states = {}
var actives = {}

var vm_size = Vector2(0, 0)
var game_size

var compiler
var level

var root

func check_screen():
	var vs = OS.get_video_mode_size()
	if vs == vm_size:
		return
	vm_size = vs
	var scale = Vector2()
	scale.x = vs.x / game_size.x
	scale.y = vs.y / game_size.y
	var ofs = Vector2(0, 0)
	if scale.x > scale.y:
		scale.x = scale.y
		ofs.x = (vs.x - game_size.x * scale.x) / 2
	else:
		scale.y = scale.x
		ofs.y = (vs.y - game_size.y * scale.y) / 2
	var m = Matrix32()
	m = m.scaled(scale)
	m[2] = ofs
	get_scene().set_viewport_global_transform( m )


func inventory_has(p_obj):
	return (p_obj in inventory) && inventory[p_obj]

func inventory_set(p_obj, p_has):
	inventory[p_obj] = p_has
	emit_signal("inventory_changed")

func say(params, level):
	get_scene().call_group(0, "dialog", "say", params, level)

func dialog_config(params):
	get_scene().call_group(0, "dialog", "config", params)

func wait(params, level):
	var time = float(params[0])
	printt("wait time ", params[0], time)
	if time <= 0:
		return state_return
	get_scene().call_group(0, "game", "wait", time, level)
	level.waiting = true
	return state_yield

func test(cmd):
	if "if_true" in cmd:
		for flag in cmd.if_true:
			if !get_global(flag):
				return false
	if "if_false" in cmd:
		for flag in cmd.if_false:
			if get_global(flag):
				return false
	if "if_inv" in cmd:
		for flag in cmd.if_inv:
			if !inventory_has(flag):
				return false
	if "if_not_inv" in cmd:
		for flag in cmd.if_not_inv:
			if inventory_has(flag):
				return false

	return true

func dialog(params, level):
	get_scene().call_group(0, "dialog_dialog", "start", params, level)

func instance_level(p_level, p_root):
	var level = { "ip": 0, "instructions": p_level, "waiting": false, "break_stop": p_root, "labels": {} }
	for i in range(p_level.size()):
		if p_level[i].name == "label":
			var lname = p_level[i].params[0]
			level.labels[lname] = i
	return level

func compile(p_path):

	var ev_table

	if p_path.find(".gd") != -1:
		var res = ResourceLoader.load(p_path)
		if res == null:
			return null
		ev_table = res.new().get_events()
	else:
		var errors = []
		ev_table = compiler.compile(p_path, errors)
		if errors.size() > 0:
			call_deferred("report_errors", p_path, errors)

	return ev_table

func report_errors(p_path, errors):
	var dialog = preload("res://game/globals/errors.xml").instance()
	var text = "Errors in file "+p_path+"\n\n"
	for e in errors:
		text += e+"\n"
	dialog.set_text(text)
	root.get_node("layers/telon").add_child(dialog)

func add_level(p_level, p_root):
	stack.push_back(instance_level(p_level, p_root))
	return state_call
	#run()
	#var ret =  run_top()
	#return ret

func run_event(p_event):
	root.set_input_catch(true)
	add_level(p_event, true)

func get_global(name):
	return (name in globals) && globals[name]

func set_global(name, val):
	globals[name] = val
	emit_signal("global_changed", [name])

func get_object(name):
	if !(name in objects):
		return null
	return objects[name]

func register_object(name, val):
	objects[name] = val
	if name in states:
		val.set_state(states[name])
	if name in actives:
		val.set_active(actives[name])
	val.connect("exit_scene", self, "object_exit_scene", [name])

func set_state(name, state):
	states[name] = state

func set_active(name, active):
	actives[name] = active

func object_exit_scene(name):
	globals.erase(name)

func idle(time):
	check_screen()
	run()

func run_top():
	var top = stack[stack.size()-1]
	var ret = level.resume(top)
	if ret == state_return || ret == state_break:
		stack.remove(stack.size()-1)
	return ret

func jump(p_label):
	while stack.size() > 0:
		var top = stack[stack.size()-1]
		printt("top labels: ", top.labels, p_label)
		if p_label in top.labels:
			top.ip = top.labels[p_label]
			return
		else:
			if top.break_stop || stack.size() == 1:
				report_errors("", ["Label not found: "+p_label+", can't jump"])
				stack.remove(stack.size()-1)
				break
			else:
				stack.remove(stack.size()-1)

func run():
	if stack.size() == 0:
		return
	while stack.size() > 0:
		var ret = run_top()
		if ret == state_yield:
			return
		if ret == state_break:
			while stack.size() > 0 && !(stack[stack.size()-1].break_stop):
				stack.remove(stack.size()-1)
			stack.remove(stack.size()-1)
	root.set_input_catch(false)

func can_interact():
	return stack.size() == 0

func finished(context):
	context.waiting = false

func change_scene(params, context):
	var res = ResourceLoader.load(params[0])
	var scene = res.instance()
	if scene:
		root.set_scene(scene)
	else:
		report_errors("", ["Failed loading scene "+params[0]+" for change_scene"])
	context.waiting = false

func spawn(params):
	var res = ResourceLoader.load(params[0])
	var scene = res.instance()
	if scene:
		root.get_scene().add_child(scene)
	else:
		report_errors("", ["Failed loading scene "+params[0]+" for spawn"])
		return state_return
	if params.size() > 1:
		var obj = get_object(params[1])
		if obj:
			scene.set_pos(obj.get_global_pos());
		else:
			report_errors("", ["Global id "+params[1]+" not found for spawn"])
	return state_return

func save(p_fname):

	if stack.size() != 0:
		print("Unable to save, script is busy")
		return

	var f = File.new()
	f.open(p_fname, File.WRITE)
	if !f.is_open():
		print("Unable to open file for save ", p_fname)
		return false

	f.store_string(":load\n\n")


	f.store_string("cut_scene telon fade_out\n\n")

	f.store_string("## Global flags\n\n")
	for k in globals.keys():
		if !globals[k]:
			continue
		f.store_string("set_global " + k + " true\n")
	f.store_string("\n")

	f.store_string("## Inventory\n\n")
	for k in inventory.keys():
		if !inventory[k]:
			continue
		f.store_string("inventory_add " + k + "\n")
	f.store_string("\n")

	f.store_string("## Objects\n\n")
	var objs = {}
	for k in states.keys():
		objs[k] = true
	for k in actives.keys():
		objs[k] = true
	for k in objs.keys():
		if k in actives:
			var s = "true"
			if !actives[k]:
				s = "false"
			f.store_string("set_active " + k + " " + s + "\n")

		if k in states:
			f.store_string("set_state " + k + " " + states[k] + "\n")

		f.store_string("\n")

	f.store_string("\n")
	f.store_string("## Player\n\n")

	f.store_string("change_scene " + root.get_current_scene().get_filename() + "\n")

	var pos = root.get_current_scene().get_node("player").get_global_pos()
	f.store_string("teleport_pos player " + str(pos.x) + " " + str(pos.y) + "\n")

	f.store_string("\ncut_scene telon fade_in\n")

	f.close()

	return true

func clear():
	stack = []
	globals = {}
	objects = {}
	inventory = {}
	get_scene().call_group(0, "game", "game_cleared")


func init():
	add_user_signal("global_changed", ["name"])
	add_user_signal("inventory_changed")
	compiler = preload("res://game/globals/esc_compile.gd").new()
	level = preload("res://game/globals/vm_level.gd").new()
	level.set_vm(self)
	game_size = Vector2()
	game_size.x = Globals.get("video_mode/game_width")
	game_size.y = Globals.get("video_mode/game_height")

	if !Globals.has("debug/skip_cache") || !Globals.get("debug/skip_cache"):
		scenes_cache.push_back(preload("res://game/player/player.xml"))
		scenes_cache.push_back(preload("res://game/globals/game.xml"))
		#scenes_cache.push_back(preload("res://game/objects/ghost_hound.xml"))
		#scenes_cache.push_back(preload("res://game/objects/on_stage/tv_02.xml"))

	root = get_scene().get_root_node()
	if root extends preload("res://game/main.gd"):
		var scene = preload("res://game/ui/main_menu.xml").instance()
		root.set_scene(scene)
	else:
		var main = preload("res://game/main.xml").instance()
		get_scene().set_root_node(main)
		main.set_scene(root)
		root = main

