

tool

export(Image) var terrain
export(Image) var scales
export(Image) var lightmap
export var scale_min = 0.3
export var scale_max = 1.0
export var modulate = Color(1, 1, 1, 1)
var texture
var img_area

var path

func make_local(pos):
	pos = pos - get_pos()
	pos = pos * 1.0 / get_scale()
	return pos

func make_global(pos):
	pos = pos * get_scale()
	pos = pos + get_pos()
	return pos

func _find_solid(p_dest, dir_x, dir_y):
	var pos = p_dest
	var size = path.get_size()
	while pos.x >= 0 && pos.x < size.x && pos.y >= 0 && pos.y < size.y:
		if !path.is_solid(pos):
			return pos
		pos.x += dir_x
		pos.y += dir_y

	return Vector2(-1, -1)

func _find_nearest(p_dest):
	var final = Vector2(-1, -1)
	var dist = 1000000

	var dirs_x = [0, 0, 1, -1]
	var dirs_y = [1, -1, 0, 0]
	for i in range(0, 4):
		var s = _find_solid(p_dest, dirs_x[i], dirs_y[i])
		if s.x != -1:
			var d = s.distance_squared_to(p_dest)
			if final.x == -1 || d < dist:
				dist = d
				final = s

	return final


func get_path(p_src, p_dest):
	p_src = make_local(p_src)
	p_dest = make_local(p_dest)
	var size = path.get_size()
	if p_dest.x < 0:
		p_dest.x = 0
	if p_dest.x >= size.x:
		p_dest.x = size.x - 1
	if p_dest.y < 0:
		p_dest.y = 0
	if p_dest.y >= size.y:
		p_dest.y = size.y - 1
	if path.is_solid(p_dest):
		p_dest = _find_nearest(p_dest)
		if p_dest.x == -1:
			return []
	if path.is_solid(p_src):
		p_src = _find_nearest(p_src)
		if p_src.x == -1:
			return []
	var r_path = path.find_path(p_src, p_dest, true)
	for i in range(0, r_path.size()):
		r_path[i] = make_global(r_path[i])
	return r_path

func get_scale_range(r):
	r = scale_min + (scale_max - scale_min) * r
	return Vector2(r, r)

func get_terrain(pos):
	if typeof(terrain) == typeof(null) || terrain.empty():
		return Color(1, 1, 1, 1)
	return get_pixel(pos, scales)

func _color_mul(a, b):
	var c = Color()
	c.r = a.r * b.r
	c.g = a.g * b.g
	c.b = a.b * b.b
	c.a = a.a * b.a
	return c

func get_light(pos):
	if typeof(lightmap) == typeof(null) || lightmap.empty():
		return modulate
	return _color_mul(get_pixel(pos, lightmap), modulate)

func get_pixel(pos, p_image):

	pos = make_local(pos)

	var ll = p_image.get_pixel(pos.x, pos.y)
	var ndif = Vector2()
	ndif.x = pos.x - floor(pos.x)
	ndif.y = pos.y - floor(pos.y)
	var ur

	img_area = Rect2(0, 0, p_image.get_width(), p_image.get_height())

	var lr = ll
	if ndif.x > 0 && img_area.has_point(Vector2(pos.x+1, pos.y)):
		lr = p_image.get_pixel(pos.x+1, pos.y)
		#if lr.a < 128:
		#	lr = ll
		ur = lr

	var ul = ll
	if ndif.y > 0 && img_area.has_point(Vector2(pos.x, pos.y+1)):
		ul = p_image.get_pixel(pos.x, pos.y+1)
		#if ul.a < 128:
		#	ul = ll
		ur = ul

	if ndif.x > 0 && ndif.y > 0 && img_area.has_point(Vector2(pos.x+1, pos.y+1)):
		var pix = p_image.get_pixel(pos.x+1, pos.y+1)
		#if pix.a > 128:
		ur = pix

	var bottom = ll.linear_interpolate(lr, ndif.x)
	var top = ul.linear_interpolate(ur, ndif.x)

	var final = bottom.linear_interpolate(top, ndif.y)

	return final


func _draw():
	if typeof(texture) == typeof(null):
		return
	#if !get_scene().is_editor_hint():
	#	printt("*********no editor hint")
	#	return
	var scale = get_scale()

	var rect = Rect2(0, 0, texture.get_width() * scale.x, texture.get_height() * scale.y)
	draw_texture(texture, Vector2(0, 0))

func _ready():
	path = ImagePathFinder.new()
	if typeof(terrain) != typeof(null):
		texture = Texture.new()
		texture.create_from_image(terrain)
		path.create_from_image_alpha(terrain)

