extends ResourcePreloader

var vm
var telon
var wait_timer
var wait_level

func set_input_catch(p_catch):
	telon.set_input_catch(p_catch)

func set_scene(p_scene):
	if get_child_count() > 1:
		var old = get_child(0)
		old.free()
	add_child(p_scene)
	move_child(p_scene, 0)

func get_current_scene():
	if get_child_count() <= 1:
		return null
	return get_child(0)

func get_scene():
	if get_child_count() > 1:
		return get_child(0)
	else:
		return null

func wait_finished():
	vm.finished(wait_level)

func wait(time, level):
	wait_level = level
	wait_timer.set_wait_time(time)
	wait_timer.set_one_shot(true)
	wait_timer.start()

func _ready():
	vm = .get_scene().get_singleton("vm")
	telon = get_node("layers/telon/telon")
	wait_timer = get_node("layers/wait_timer")
	wait_timer.connect("timeout", self, "wait_finished")
	add_to_group("game")

