extends Node2D

var task
var walk_destination
var animation
var vm
var terrain
var walk_path
var path_ofs
export var speed = 300
export var v_speed_damp = 1
var dir_angles = [22.5, 82.5, 97.5, 157.5,			202.5, 262.5, 277.5, 337.5 ]
var directions = ["frente", 1, "3cuartos_izquierda", -1, "perfil_izquierda", -1, "3cuartos_espalda_derecha", 1,
			"espalda", 1, "3cuartos_espalda_derecha", -1, "perfil_izquierda", 1, "3cuartos_izquierda", 1]
var idles = ["idle_frente",	1, "idle_3cuartos_izquierda", -1, "idle_perfil_izquierda", -1, "idle_3cuartos_espalda_derecha", 1,
			"idle_espalda", 1, "idle_3cuartos_espalda_derecha", -1, "idle_perfil_izquierda", 1, "idle_3cuartos_izquierda", 1]
var speaks = ["talk_frente", 1, "talk_34", -1, "talk_perfil", -1, "idle_3cuartos_espalda_derecha", 1,
			"idle_espalda", 1, "idle_3cuartos_espalda_derecha", -1, "talk_perfil", 1, "talk_34", 1]
var last_dir = 0
var last_scale
var pose_scale = 1
var params_queue
var camera
export var camera_limits = Rect2()

var anim_notify = null
var sprites = []

func walk_to(pos):
	walk_destination = pos
	walk_path = terrain.get_path(get_pos(), pos)
	if walk_path.size() == 0:
		task = null
		walk_stop(get_pos())
		#set_process(false)
		return
	path_ofs = 0.0
	task = "walk"
	set_process(true)
	params_queue = null

func anim_finished():
	if typeof(anim_notify) != typeof(null):
		vm.finished(anim_notify)
		anim_notify = null


func set_speaking(p_speaking):
	if p_speaking:
		animation.play(speaks[last_dir])
		pose_scale = idles[last_dir + 1]
	else:
		animation.play(idles[last_dir])
		pose_scale = speaks[last_dir + 1]
	_update_terrain()

func _find(p_val, p_array):
	var i = 0
	for v in p_array:
		if typeof(v) == typeof(p_val) && v == p_val:
			return i
		i += 1
	return -1

func play_anim(p_anim, p_notify = null):
	if typeof(p_notify) != typeof(null) && (!has_node("animation") || !get_node("animation").has_animation(p_anim)):
		vm.finished(p_notify)
		return
	get_node("animation").play(p_anim)
	anim_notify = p_notify
	var dir = _find(p_anim, directions)
	if dir == -1:
		dir = _find(p_anim, idles)
	if dir != -1:
		last_dir = dir


func interact(p_params):
	var pos
	if p_params[0].inventory:
		get_scene().call_group(0, "game", "interact", p_params)
		return
	if p_params[0].has_node("interact_pos"):
		pos = p_params[0].get_node("interact_pos").get_global_pos()
	else:
		pos = p_params[0].get_global_pos()
	if get_global_pos().distance_to(pos) > 10:
		walk_to(pos)
		params_queue = p_params
	else:
		if typeof(p_params[0].interact_pose) != typeof(null):
			last_dir = p_params[0].interact_pose * 2
			animation.play(idles[last_dir])
			pose_scale = idles[last_dir + 1]
			_update_terrain()
		get_scene().call_group(0, "game", "interact", p_params)

func walk_stop(pos):
	set_pos(pos)
	task = null
	#set_process(false)
	if typeof(params_queue) != typeof(null):
		if typeof(params_queue[0].interact_pose) != typeof(null):
			last_dir = params_queue[0].interact_pose * 2
			animation.play(idles[last_dir])
			pose_scale = idles[last_dir + 1]
			_update_terrain()
		else:
			animation.play(idles[last_dir])
		get_scene().call_group(0, "game", "interact", params_queue)
	else:
		animation.play(idles[last_dir])
	_update_terrain()

func _get_dir(angle):
	var deg = rad2deg(angle) + 180
	var dir = 0
	var i = 0
	for ang in dir_angles:
		if deg < ang:
			dir = i
			break
		i+=2
	return dir


func _process(time):

	if task == "walk":
		var to_walk = speed * last_scale.x * last_scale.x * time
		var pos = get_pos()
		var old_pos = pos
		var next
		while to_walk > 0:
			var next
			if walk_path.size() > 1:
				next = walk_path[path_ofs + 1]
			else:
				next = walk_path[path_ofs]

			var dist = pos.distance_to(next)
			var dif = next - pos
			var l = dif.length()
			var damp = abs(v_speed_damp + ((1 - v_speed_damp) * abs(dif.x / l)))
			dist = dist * (1 / damp)
			#printt("damp ", damp, dif.x / l)

			if dist > to_walk:
				var n = (next - pos).normalized()
				pos = pos + n * to_walk * damp
				break
			pos = next
			to_walk -= dist
			path_ofs += 1
			if path_ofs >= walk_path.size() - 1:
				walk_stop(pos)
				return

		var angle = old_pos.angle_to(pos)
		set_pos(pos)

		last_dir = _get_dir(angle)

		if animation.get_current_animation() != directions[last_dir]:
			animation.play(directions[last_dir])
		pose_scale = directions[last_dir+1]

	_update_terrain()


func _update_terrain():
	var pos = get_pos()
	var color = terrain.get_terrain(pos)
	last_scale = terrain.get_scale_range(color.b)
	set_scale(Vector2(last_scale.x * pose_scale, last_scale.y))
	color = terrain.get_light(pos)
	for s in sprites:
		s.set_modulate(color)


func teleport(obj):
	if typeof(obj.interact_pose) != typeof(null):
		last_dir = obj.interact_pose * 2
		animation.play(idles[last_dir])
		pose_scale = idles[last_dir + 1]

	var pos
	if obj.has_node("interact_pos"):
		pos = obj.get_node("interact_pos").get_global_pos()
	else:
		pos = obj.get_global_pos()

	set_pos(pos)
	_update_terrain()

func teleport_pos(x, y):
	set_pos(Vector2(x, y))
	_update_terrain()


func _find_sprites(p = null):
	if p.is_type("Sprite") || p.is_type("AnimatedSprite"):
		sprites.push_back(p)
	for i in range(0, p.get_child_count()):
		_find_sprites(p.get_child(i))


func _ready():
	animation = get_node("animation")
	vm = get_scene().get_singleton("vm")
	vm.register_object("player", self)
	terrain = get_parent().get_node("terrain")
	#_update_terrain();
	if has_node("animation"):
		get_node("animation").connect("finished", self, "anim_finished")

	camera = get_node("camera")

	if camera_limits.size.x == 0 && camera_limits.size.y == 0:
		var p = get_parent()
		var area = Rect2()
		for i in range(0, p.get_child_count()):
			var c = p.get_child(i)
			if !(c extends preload("res://game/objects/background.gd")):
				continue
			var pos = c.get_global_pos()
			var size = c.get_minimum_size()
			printt("extending to ", area, pos, pos + size)
			area = area.expand(pos)
			area = area.expand(pos + size)

		camera.set_limit(MARGIN_LEFT, area.pos.x)
		camera.set_limit(MARGIN_RIGHT, area.pos.x + area.size.x)
		camera.set_limit(MARGIN_TOP, area.pos.y)
		camera.set_limit(MARGIN_BOTTOM, area.pos.y + area.size.y)
	else:
		camera.set_limit(MARGIN_LEFT, camera_limits.pos.x)
		camera.set_limit(MARGIN_RIGHT, camera_limits.pos.x + camera_limits.size.x)
		camera.set_limit(MARGIN_TOP, camera_limits.pos.y)
		camera.set_limit(MARGIN_BOTTOM, camera_limits.pos.y + camera_limits.size.y)

	_find_sprites(self)

	set_process(true)

