extends Control

var vm

func load_game(p_game):
	var game = vm.compile(p_game)
	vm.run_event(game["load"])


func _ready():
	get_node("new").connect("pressed", self, "load_game", ["res://game/globals/game.esc"])
	get_node("restore").connect("pressed", self, "load_game", [OS.get_data_dir() + "/quick_save.esc"])
	get_node("skip").connect("pressed", self, "load_game", ["res://game/globals/skip.esc"])
	vm = get_scene().get_singleton("vm")

