var vm

var player
var pending_command = ""
var pending_params = []
var mode = "default"
var action_menu
var inventory
export(String,FILE) var fallbacks_path = ""
var fallbacks

var click
var click_anim

func set_mode(p_mode):
	mode = p_mode

func mouse_enter(obj):
	var text
	if pending_command != "":
		text = pending_command + " " + pending_params[0].tooltip + " with "
		if obj != pending_params[0]:
			text = text + obj.tooltip
	elif obj.inventory:
		var action = inventory.get_action_text()
		text = action + " " + obj.tooltip + " with "
	else:
		text = obj.tooltip
	get_scene().call_group(0, "hud", "set_tooltip", text)

func mouse_exit(obj):
	var text
	if pending_command != "":
		text = pending_command + " " + pending_params[0].tooltip + " with "
	else:
		text = ""
	get_scene().call_group(0, "hud", "set_tooltip", text)

func clear_action():
	pending_command = ""
	pending_params.clear()

func clicked(obj, pos):
	if !vm.can_interact():
		return
	if mode == "default":
		var action = obj.get_action()
		action_menu.hide()
		if action == "walk":
			click.set_pos(pos)
			click_anim.play("click")
			player.walk_to(pos)
			pending_command = ""
			pending_params.clear()
			get_scene().call_group(0, "hud", "set_tooltip", "")

		elif obj.inventory:
			if pending_command == "use":
				interact([obj, pending_command, pending_params[0]])
			else:
				interact([obj, inventory.current_action])
		else:
			if pending_command == "use":
				if obj.inventory:
					interact([obj, pending_command, pending_params[0]])
				else:
					player.interact([obj, pending_command, pending_params[0]])
			else:
				if obj.use_action_menu:
					if pending_command == "use":
						player.interact([obj, pending_command, pending_params[0]])
					else:
						spawn_action_menu(obj)
				elif action == "use" && obj.use_combine:
					pending_command = "use"
					pending_params.push_back(obj)
					mouse_enter(obj)
				else:
					click.set_pos(pos)
					#click_anim.play("click")
					player.interact([obj, action])

func spawn_action_menu(obj):
	action_menu.show()
	var pos
	if obj.has_node("action_menu_pos"):
		pos = obj.get_node("action_menu_pos").get_global_pos()
	else:
		pos = obj.get_global_pos()
	action_menu.set_pos(pos)
	action_menu.start(obj)

func action_menu_selected(obj, action):
	printt("action menu selected!", obj, action)
	if action == "use" && obj.get_action() != "":
		action = obj.get_action()
	print("new action is ", action)
	player.interact([obj, action])
	action_menu.hide()

func interact(p_params):
	if mode == "default":
		var obj = p_params[0]
		clear_action()
		var action = p_params[1]
		if !action:
			action = obj.get_action()

		if p_params.size() > 2:
			clear_action()
			if obj == p_params[2]:
				return
			inventory.close()
			activate(obj, action, p_params[2])
		elif action == "use" && obj.use_combine:
			pending_command = "use"
			pending_params.push_back(obj)
			mouse_enter(obj)
		else:
			inventory.close()
			activate(obj, action)
			clear_action()

		return

func activate(obj, action, param = null):
	if !obj.activate(action, param):
		fallback(obj, action, param)

func fallback(obj, action, param = null):
	var comb = action
	if typeof(param) != typeof(null):
		comb = action + " " + param.global_id
		if comb in fallbacks:
			vm.run_event(fallbacks[comb])
			return
	if action in fallbacks:
		vm.run_event(fallbacks[action])
		return
	vm.report_errors(fallbacks_path, ["Invalid action " + comb + " in fallbacks."])

func _input(event):
	if event.is_action("quick_save") && event.is_pressed() && !event.is_echo():
		var fname = OS.get_data_dir() + "/quick_save.esc"
		print("**** Saving to ", fname)
		vm.save(fname)

func _ready():
	add_to_group("game")
	vm = get_scene().get_singleton("vm")
	player = get_node("../player")
	action_menu = get_node("action_menu")
	inventory = get_node("hud_layer/hud/inventory")
	if fallbacks_path != "":
		fallbacks = vm.compile(fallbacks_path)

	click = get_node("click")
	click_anim = get_node("click_anim")
	set_process_input(true)
